/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import jpos.JposException;

public class BitmapConverter {
    private int[][] m_pixels;
    private int m_height;
    private int m_width;
    private int m_threshold = 128;

    public BitmapConverter(Image image, int n, int n2) throws JposException {
        int n3;
        Object object;
        BufferedImage bufferedImage;
        this.m_threshold = n2;
        switch (n) {
            default: 
        }
        try {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            object = bufferedImage.createGraphics();
            ((Graphics)object).setColor(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, image.getWidth(null), image.getHeight(null));
            ((Graphics)object).drawImage(image, 0, 0, null);
            ((Graphics)object).dispose();
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        switch (n) {
            default: 
        }
        this.m_height = bufferedImage.getHeight();
        this.m_width = bufferedImage.getWidth();
        this.m_pixels = new int[this.m_width + 7][this.m_height + 7];
        object = new int[this.m_width * this.m_height];
        object = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])object, 0, this.m_width);
        switch (n) {
            default: {
                for (n3 = 0; n3 < this.m_height; ++n3) {
                    for (int i = 0; i < this.m_width; ++i) {
                        this.m_pixels[i][n3] = (int)object[n3 * this.m_width + i];
                    }
                }
                break;
            }
            case 259: {
                n3 = bufferedImage.getWidth() * bufferedImage.getHeight() - 1;
                for (int i = 0; i < this.m_height; ++i) {
                    for (int j = 0; j < this.m_width; ++j) {
                        this.m_pixels[j][i] = (int)object[n3--];
                    }
                }
            }
        }
        if ((n3 = 0) != 0) {
            this.effectDiffusion();
        }
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getThreshold() {
        return this.m_threshold;
    }

    public boolean isPixelBlack(int n, int n2) {
        int n3 = this.m_pixels[n][n2];
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        Color color = new Color(n3);
        if (color.getAlpha() == 0) {
            return false;
        }
        return n4 * 30 + n5 * 59 + n6 * 11 < this.getThreshold() * 100;
    }

    private int getPixelGreyLevel(int n, int n2) {
        int n3 = this.m_pixels[n][n2];
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        float f = 1.5f;
        Color color = new Color(n3);
        if (color.getAlpha() == 0) {
            return 255;
        }
        int n7 = (int)((float)((double)(n4 + n5 + n6) / 3.0) * f);
        if (n7 > 255) {
            n7 = 255;
        }
        return n7;
    }

    private void effectDiffusion() {
        int[][] nArray = new int[this.m_width][this.m_height];
        for (int i = 0; i < this.m_height; ++i) {
            int n;
            int n2;
            if ((i & 1) == 0) {
                for (n2 = 0; n2 < this.m_width; ++n2) {
                    int[] nArray2 = nArray[n2];
                    int n3 = i;
                    nArray2[n3] = nArray2[n3] + (255 - this.getPixelGreyLevel(n2, i));
                    if (nArray[n2][i] >= 255) {
                        this.m_pixels[n2][i] = Color.BLACK.getRGB();
                        int[] nArray3 = nArray[n2];
                        int n4 = i;
                        nArray3[n4] = nArray3[n4] - 255;
                    } else {
                        this.m_pixels[n2][i] = Color.WHITE.getRGB();
                    }
                    n = nArray[n2][i] / 16;
                    if (n2 >= this.m_width - 1) continue;
                    int[] nArray4 = nArray[n2];
                    int n5 = i + 1;
                    nArray4[n5] = nArray4[n5] + n * 5;
                    if (n2 > 0) {
                        int[] nArray5 = nArray[n2 - 1];
                        int n6 = i + 1;
                        nArray5[n6] = nArray5[n6] + n * 3;
                    }
                    if (n2 >= this.m_width - 1) continue;
                    int[] nArray6 = nArray[n2 + 1];
                    int n7 = i + 1;
                    nArray6[n7] = nArray6[n7] + n * 1;
                }
                continue;
            }
            for (n2 = this.m_width - 1; n2 >= 0; --n2) {
                int[] nArray7 = nArray[n2];
                int n8 = i;
                nArray7[n8] = nArray7[n8] + (255 - this.getPixelGreyLevel(n2, i));
                if (nArray[n2][i] >= 255) {
                    this.m_pixels[n2][i] = Color.BLACK.getRGB();
                    int[] nArray8 = nArray[n2];
                    int n9 = i;
                    nArray8[n9] = nArray8[n9] - 255;
                } else {
                    this.m_pixels[n2][i] = Color.WHITE.getRGB();
                }
                n = nArray[n2][i] / 16;
                if (n2 > 0) {
                    int[] nArray9 = nArray[n2 - 1];
                    int n10 = i;
                    nArray9[n10] = nArray9[n10] + n * 7;
                }
                if (i >= this.m_height - 1) continue;
                int[] nArray10 = nArray[n2];
                int n11 = i + 1;
                nArray10[n11] = nArray10[n11] + n * 5;
                if (n2 < this.m_width - 1) {
                    int[] nArray11 = nArray[n2 + 1];
                    int n12 = i + 1;
                    nArray11[n12] = nArray11[n12] + n * 3;
                }
                if (n2 <= 0) continue;
                int[] nArray12 = nArray[n2 - 1];
                int n13 = i + 1;
                nArray12[n13] = nArray12[n13] + n * 1;
            }
        }
    }
}

